<?php

$this->pageTitle = ''.Yii::app()->name.' - Szkolenia';

$this->breadcrumbs = array(
	'Szkolenia'
);

?>
<h1>Szkolenia</h1>

<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('create') ?>">Dodaj nowe szkolenie</a>

<?php

$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'szkolenie-grid',
	'dataProvider'=>$model->with(array('dziedzina'))->search(),
	'filter' => $model,
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		'id',
		'nazwa',
		array(
			'name' => 'idDziedzina',
			'value' => '$data->dziedzina->nazwa',
		),
		array(
			'name' => 'poziom',
			'value' => '$data->poziomStr',
		),
		array(
			'name' => 'czyEgzamin',
			'value' => '$data->czyEgzamin ? "Tak" : "Nie"',
		),
		array(
			'name' => 'czasTrwania',
			'value' => 'sprintf("%02d:%02d:%02d", (int)$data->czasTrwania / 3600, (int)$data->czasTrwania / 60, (int)$data->czasTrwania % 60)',
		),
		array(
			'class'=>'CButtonColumn',
		),
	),
));

?>
